#ifndef SVG_COLORS_H
#define SVG_COLORS_H


/* color palette according SVG */
extern color_t svg_colors[256];


/* colors according SVG 1.0 */
/* all names of the colors are without spaces, in upper case */


#define RGB(R,G,B)           ((((((0xFFUL << 8) | R) << 8) | G) << 8) | B)
#define IRGB(I,R,G,B)        ((I << 24) | (R << 16) | (G << 8) | B)


#define BLACK                IRGB(  0,   0,   0,   0)
#define WHITE                IRGB(  1, 255, 255, 255)
#define RED                  IRGB(  2, 255,   0,   0)
#define LIME                 IRGB(  3,   0, 255,   0)
#define BLUE                 IRGB(  4,   0,   0, 255)
#define CYAN                 IRGB(  5,   0, 255, 255)
#define AQUA                 IRGB(  5,   0, 255, 255)
#define FUCHSIA              IRGB(  6, 255,   0, 255)
#define MAGENTA              IRGB(  6, 255,   0, 255)
#define YELLOW               IRGB(  7, 255, 255,   0)
                                       
#define GRAY                 IRGB(  8, 128, 128, 128)
#define GREY                 IRGB(  8, 128, 128, 128)
#define SILVER               IRGB(  9, 192, 192, 192)
#define MAROON               IRGB( 10, 128,   0,   0)
#define GREEN                IRGB( 11,   0, 128,   0)
#define NAVY                 IRGB( 12,   0,   0, 128)
#define TEAL                 IRGB( 13,   0, 128, 128)
#define PURPLE               IRGB( 14, 128,   0, 128)
#define OLIVE                IRGB( 15, 128, 128,   0)
                                       
/* red */                              
#define INDIANRED            IRGB( 16, 205,  92,  92)
#define LIGHTCORAL           IRGB( 17, 240, 128, 128)
#define SALMON               IRGB( 18, 250, 128, 114)
#define DARKSALMON           IRGB( 19, 233, 150, 122)
#define LIGHTSALMON          IRGB( 20, 255, 160, 122)
#define CRIMSON              IRGB( 21, 220,  20,  60)
#define FIREBRICK            IRGB( 22, 178,  34,  34)
#define DARKRED              IRGB( 23, 139,   0,   0)
                                       
/* pink */                             
#define PINK                 IRGB( 24, 255, 192, 203)
#define LIGHTPINK            IRGB( 25, 255, 182, 193)
#define HOTPINK              IRGB( 26, 255, 105, 180)
#define DEEPPINK             IRGB( 27, 255,  20, 147)
#define MEDIUMVIOLETRED      IRGB( 28, 199,  21, 133)
#define PALEVIOLETRED        IRGB( 29, 219, 112, 147)
                                       
/* orange */                           
#define CORAL                IRGB( 30, 255, 127,  80)
#define TOMATO               IRGB( 31, 255,  99,  71)
#define ORANGERED            IRGB( 32, 255,  69,   0)
#define DARKORANGE           IRGB( 33, 255, 140,   0)
#define ORANGE               IRGB( 34, 255, 165,   0)
                                       
/* yellow */                           
#define GOLD                 IRGB( 35, 255, 215,   0)
#define LIGHTYELLOW          IRGB( 36, 255, 255, 224)
#define LEMONCHIFFON         IRGB( 37, 255, 250, 205)
#define LIGHTGOLDENRODYELLOW IRGB( 38, 250, 250, 210)
#define PAPAYAWHIP           IRGB( 39, 255, 239, 213)
#define MOCCASIN             IRGB( 40, 255, 228, 181)
#define PEACHPUFF            IRGB( 41, 255, 218, 185)
#define PALEGOLDENROD        IRGB( 42, 238, 232, 170)
#define KHAKI                IRGB( 43, 240, 230, 140)
#define DARKKHAKI            IRGB( 44, 189, 183, 107)
                                       
/* purple */                           
#define LAVENDER             IRGB( 45, 230, 230, 250)
#define THISTLE              IRGB( 46, 216, 191, 216)
#define PLUM                 IRGB( 47, 221, 160, 221)
#define VIOLET               IRGB( 48, 238, 130, 238)
#define ORCHID               IRGB( 49, 218, 112, 214)
#define MEDIUMORCHID         IRGB( 50, 186,  85, 211)
#define MEDIUMPURPLE         IRGB( 51, 147, 112, 219)
#define BLUEVIOLET           IRGB( 52, 138,  43, 226)
#define DARKVIOLET           IRGB( 53, 148,   0, 211)
#define DARKORCHID           IRGB( 54, 153,  50, 204)
#define DARKMAGENTA          IRGB( 55, 139,   0, 139)
#define INDIGO               IRGB( 56,  75,   0, 130)
#define SLATEBLUE            IRGB( 57, 106,  90, 205)
#define DARKSLATEBLUE        IRGB( 58,  72,  61, 139)
#define MEDIUMSLATEBLUE      IRGB( 59, 123, 104, 238)
                                       
/* green */                            
#define GREENYELLOW          IRGB( 60, 173, 255,  47)
#define CHARTREUSE           IRGB( 61, 127, 255,   0)
#define LAWNGREEN            IRGB( 62, 124, 252,   0)
#define LIMEGREEN            IRGB( 63,  50, 205,  50)
#define PALEGREEN            IRGB( 64, 152, 251, 152)
#define LIGHTGREEN           IRGB( 65, 144, 238, 144)
#define MEDIUMSPRINGGREEN    IRGB( 66,   0, 250, 154)
#define SPRINGGREEN          IRGB( 67,   0, 255, 127)
#define MEDIUMSEAGREEN       IRGB( 68,  60, 179, 113)
#define SEAGREEN             IRGB( 69,  46, 139,  87)
#define FORESTGREEN          IRGB( 70,  34, 139,  34)
#define DARKGREEN            IRGB( 71,   0, 100,   0)
#define YELLOWGREEN          IRGB( 72, 154, 205,  50)
#define OLIVEDRAB            IRGB( 73, 107, 142,  35)
#define DARKOLIVEGREEN       IRGB( 74,  85, 107,  47)
#define MEDIUMAQUAMARINE     IRGB( 75, 102, 205, 170)
#define DARKSEAGREEN         IRGB( 76, 143, 188, 143)
#define LIGHTSEAGREEN        IRGB( 77,  32, 178, 170)
#define DARKCYAN             IRGB( 78,   0, 139, 139)
                                       
/* blue */                             
#define LIGHTCYAN            IRGB( 79, 224, 255, 255)
#define PALETURQUOISE        IRGB( 80, 175, 238, 238)
#define AQUAMARINE           IRGB( 81, 127, 255, 212)
#define TURQUOISE            IRGB( 82,  64, 224, 208)
#define MEDIUMTURQUOISE      IRGB( 83,  72, 209, 204)
#define DARKTURQUOISE        IRGB( 84,   0, 206, 209)
#define CADETBLUE            IRGB( 85,  95, 158, 160)
#define STEELBLUE            IRGB( 86,  70, 130, 180)
#define LIGHTSTEELBLUE       IRGB( 87, 176, 196, 222)
#define POWDERBLUE           IRGB( 88, 176, 224, 230)
#define LIGHTBLUE            IRGB( 89, 173, 216, 230)
#define SKYBLUE              IRGB( 90, 135, 206, 235)
#define LIGHTSKYBLUE         IRGB( 91, 135, 206, 250)
#define DEEPSKYBLUE          IRGB( 92,   0, 191, 255)
#define DODGERBLUE           IRGB( 93,  30, 144, 255)
#define CORNFLOWERBLUE       IRGB( 94, 100, 149, 237)
#define ROYALBLUE            IRGB( 95,  65, 105, 225)
#define MEDIUMBLUE           IRGB( 96,   0,   0, 205)
#define DARKBLUE             IRGB( 97,   0,   0, 139)
#define MIDNIGHTBLUE         IRGB( 98,  25,  25, 112)
                                       
/* brown */                            
#define CORNSILK             IRGB( 99, 255, 248, 220)
#define BLANCHEDALMOND       IRGB(100, 255, 235, 205)
#define BISQUE               IRGB(101, 255, 228, 196)
#define NAVAJOWHITE          IRGB(102, 255, 222, 173)
#define WHEAT                IRGB(103, 245, 222, 179)
#define BURLYWOOD            IRGB(104, 222, 184, 135)
#define TAN                  IRGB(105, 210, 180, 140)
#define ROSYBROWN            IRGB(106, 188, 143, 143)
#define SANDYBROWN           IRGB(107, 244, 164,  96)
#define GOLDENROD            IRGB(108, 218, 165,  32)
#define DARKGOLDENROD        IRGB(109, 184, 134,  11)
#define PERU                 IRGB(110, 205, 133,  63)
#define CHOCOLATE            IRGB(111, 210, 105,  30)
#define SADDLEBROWN          IRGB(112, 139,  69,  19)
#define SIENNA               IRGB(113, 160,  82,  45)
#define BROWN                IRGB(114, 165,  42,  42)
                                       
/* white */                            
#define SNOW                 IRGB(115, 255, 250, 250)
#define HONEYDEW             IRGB(116, 240, 255, 240)
#define MINTCREAM            IRGB(117, 245, 255, 250)
#define AZURE                IRGB(118, 240, 255, 255)
#define ALICEBLUE            IRGB(119, 240, 248, 255)
#define GHOSTWHITE           IRGB(120, 248, 248, 255)
#define WHITESMOKE           IRGB(121, 245, 245, 245)
#define SEASHELL             IRGB(122, 255, 245, 238)
#define BEIGE                IRGB(123, 245, 245, 220)
#define OLDLACE              IRGB(124, 253, 245, 230)
#define FLORALWHITE          IRGB(125, 255, 250, 240)
#define IVORY                IRGB(126, 255, 255, 240)
#define ANTIQUEWHITE         IRGB(127, 250, 235, 215)
#define LINEN                IRGB(128, 250, 240, 230)
#define LAVENDERBLUSH        IRGB(129, 255, 240, 245)
#define MISTYROSE            IRGB(130, 255, 228, 225)
                                       
/* grey */                             
#define GAINSBORO            IRGB(131, 220, 220, 220)
#define LIGHTGRAY            IRGB(132, 211, 211, 211)
#define LIGHTGREY            IRGB(132, 211, 211, 211)
#define DARKGRAY             IRGB(133, 169, 169, 169)
#define DARKGREY             IRGB(133, 169, 169, 169)
#define DIMGRAY              IRGB(134, 105, 105, 105)
#define DIMGREY              IRGB(134, 105, 105, 105)
#define LIGHTSLATEGRAY       IRGB(135, 119, 136, 153)
#define LIGHTSLATEGREY       IRGB(135, 119, 136, 153)
#define SLATEGRAY            IRGB(136, 112, 128, 144)
#define SLATEGREY            IRGB(136, 112, 128, 144)
#define DARKSLATEGRAY        IRGB(137,  47,  79,  79)
#define DARKSLATEGREY        IRGB(137,  47,  79,  79)
                                       
/* gray scale 0-100% */                
#define GRAY0                IRGB(138,   0,   0,   0)  
#define GREY0                IRGB(138,   0,   0,   0)  
#define GRAY1                IRGB(139,   3,   3,   3)  
#define GREY1                IRGB(139,   3,   3,   3)  
#define GRAY2                IRGB(140,   5,   5,   5)  
#define GREY2                IRGB(140,   5,   5,   5)  
#define GRAY3                IRGB(141,   8,   8,   8)  
#define GREY3                IRGB(141,   8,   8,   8)  
#define GRAY4                IRGB(142,  10,  10,  10) 
#define GREY4                IRGB(142,  10,  10,  10) 
#define GRAY5                IRGB(143,  13,  13,  13) 
#define GREY5                IRGB(143,  13,  13,  13) 
#define GRAY6                IRGB(144,  15,  15,  15) 
#define GREY6                IRGB(144,  15,  15,  15) 
#define GRAY7                IRGB(145,  18,  18,  18) 
#define GREY7                IRGB(145,  18,  18,  18) 
#define GRAY8                IRGB(146,  20,  20,  20) 
#define GREY8                IRGB(146,  20,  20,  20) 
#define GRAY9                IRGB(147,  23,  23,  23) 
#define GREY9                IRGB(147,  23,  23,  23) 
#define GRAY10               IRGB(148,  26,  26,  26) 
#define GREY10               IRGB(148,  26,  26,  26) 
#define GRAY11               IRGB(149,  28,  28,  28) 
#define GREY11               IRGB(149,  28,  28,  28) 
#define GRAY12               IRGB(150,  31,  31,  31) 
#define GREY12               IRGB(150,  31,  31,  31) 
#define GRAY13               IRGB(151,  33,  33,  33) 
#define GREY13               IRGB(151,  33,  33,  33) 
#define GRAY14               IRGB(152,  36,  36,  36) 
#define GREY14               IRGB(152,  36,  36,  36) 
#define GRAY15               IRGB(153,  38,  38,  38) 
#define GREY15               IRGB(153,  38,  38,  38) 
#define GRAY16               IRGB(154,  41,  41,  41) 
#define GREY16               IRGB(154,  41,  41,  41) 
#define GRAY17               IRGB(155,  43,  43,  43) 
#define GREY17               IRGB(155,  43,  43,  43) 
#define GRAY18               IRGB(156,  46,  46,  46) 
#define GREY18               IRGB(156,  46,  46,  46) 
#define GRAY19               IRGB(157,  48,  48,  48) 
#define GREY19               IRGB(157,  48,  48,  48) 
#define GRAY20               IRGB(158,  51,  51,  51) 
#define GREY20               IRGB(158,  51,  51,  51) 
#define GRAY21               IRGB(159,  54,  54,  54) 
#define GREY21               IRGB(159,  54,  54,  54) 
#define GRAY22               IRGB(160,  56,  56,  56) 
#define GREY22               IRGB(160,  56,  56,  56) 
#define GRAY23               IRGB(161,  59,  59,  59) 
#define GREY23               IRGB(161,  59,  59,  59) 
#define GRAY24               IRGB(162,  61,  61,  61) 
#define GREY24               IRGB(162,  61,  61,  61) 
#define GRAY25               IRGB(163,  64,  64,  64) 
#define GREY25               IRGB(163,  64,  64,  64) 
#define GRAY26               IRGB(164,  66,  66,  66) 
#define GREY26               IRGB(164,  66,  66,  66) 
#define GRAY27               IRGB(165,  69,  69,  69) 
#define GREY27               IRGB(165,  69,  69,  69) 
#define GRAY28               IRGB(166,  71,  71,  71) 
#define GREY28               IRGB(166,  71,  71,  71) 
#define GRAY29               IRGB(167,  74,  74,  74) 
#define GREY29               IRGB(167,  74,  74,  74) 
#define GRAY30               IRGB(168,  77,  77,  77) 
#define GREY30               IRGB(168,  77,  77,  77) 
#define GRAY31               IRGB(169,  79,  79,  79) 
#define GREY31               IRGB(169,  79,  79,  79) 
#define GRAY32               IRGB(170,  82,  82,  82) 
#define GREY32               IRGB(170,  82,  82,  82) 
#define GRAY33               IRGB(171,  84,  84,  84) 
#define GREY33               IRGB(171,  84,  84,  84) 
#define GRAY34               IRGB(172,  87,  87,  87) 
#define GREY34               IRGB(172,  87,  87,  87) 
#define GRAY35               IRGB(173,  89,  89,  89) 
#define GREY35               IRGB(173,  89,  89,  89) 
#define GRAY36               IRGB(174,  92,  92,  92) 
#define GREY36               IRGB(174,  92,  92,  92) 
#define GRAY37               IRGB(175,  94,  94,  94) 
#define GREY37               IRGB(175,  94,  94,  94) 
#define GRAY38               IRGB(176,  97,  97,  97) 
#define GREY38               IRGB(176,  97,  97,  97) 
#define GRAY39               IRGB(177,  99,  99,  99) 
#define GREY39               IRGB(177,  99,  99,  99) 
#define GRAY40               IRGB(178, 102, 102, 102) 
#define GREY40               IRGB(178, 102, 102, 102) 
#define GRAY41               IRGB(179, 105, 105, 105) 
#define GREY41               IRGB(179, 105, 105, 105) 
#define GRAY42               IRGB(180, 107, 107, 107) 
#define GREY42               IRGB(180, 107, 107, 107) 
#define GRAY43               IRGB(181, 110, 110, 110) 
#define GREY43               IRGB(181, 110, 110, 110) 
#define GRAY44               IRGB(182, 112, 112, 112) 
#define GREY44               IRGB(182, 112, 112, 112) 
#define GRAY45               IRGB(183, 115, 115, 115) 
#define GREY45               IRGB(183, 115, 115, 115) 
#define GRAY46               IRGB(184, 117, 117, 117) 
#define GREY46               IRGB(184, 117, 117, 117) 
#define GRAY47               IRGB(185, 120, 120, 120) 
#define GREY47               IRGB(185, 120, 120, 120) 
#define GRAY48               IRGB(186, 122, 122, 122) 
#define GREY48               IRGB(186, 122, 122, 122) 
#define GRAY49               IRGB(187, 125, 125, 125) 
#define GREY49               IRGB(187, 125, 125, 125) 
#define GRAY50               IRGB(188, 127, 127, 127) 
#define GREY50               IRGB(188, 127, 127, 127) 
#define GRAY51               IRGB(189, 130, 130, 130) 
#define GREY51               IRGB(189, 130, 130, 130) 
#define GRAY52               IRGB(190, 133, 133, 133) 
#define GREY52               IRGB(190, 133, 133, 133) 
#define GRAY53               IRGB(191, 135, 135, 135) 
#define GREY53               IRGB(191, 135, 135, 135) 
#define GRAY54               IRGB(192, 138, 138, 138) 
#define GREY54               IRGB(192, 138, 138, 138) 
#define GRAY55               IRGB(193, 140, 140, 140) 
#define GREY55               IRGB(193, 140, 140, 140) 
#define GRAY56               IRGB(194, 143, 143, 143) 
#define GREY56               IRGB(194, 143, 143, 143) 
#define GRAY57               IRGB(195, 145, 145, 145) 
#define GREY57               IRGB(195, 145, 145, 145) 
#define GRAY58               IRGB(196, 148, 148, 148) 
#define GREY58               IRGB(196, 148, 148, 148) 
#define GRAY59               IRGB(197, 150, 150, 150) 
#define GREY59               IRGB(197, 150, 150, 150) 
#define GRAY60               IRGB(198, 153, 153, 153) 
#define GREY60               IRGB(198, 153, 153, 153) 
#define GRAY61               IRGB(199, 156, 156, 156) 
#define GREY61               IRGB(199, 156, 156, 156) 
#define GRAY62               IRGB(200, 158, 158, 158) 
#define GREY62               IRGB(200, 158, 158, 158) 
#define GRAY63               IRGB(201, 161, 161, 161) 
#define GREY63               IRGB(201, 161, 161, 161) 
#define GRAY64               IRGB(202, 163, 163, 163) 
#define GREY64               IRGB(202, 163, 163, 163) 
#define GRAY65               IRGB(203, 166, 166, 166) 
#define GREY65               IRGB(203, 166, 166, 166) 
#define GRAY66               IRGB(204, 168, 168, 168) 
#define GREY66               IRGB(204, 168, 168, 168) 
#define GRAY67               IRGB(205, 171, 171, 171) 
#define GREY67               IRGB(205, 171, 171, 171) 
#define GRAY68               IRGB(206, 173, 173, 173) 
#define GREY68               IRGB(206, 173, 173, 173) 
#define GRAY69               IRGB(207, 176, 176, 176) 
#define GREY69               IRGB(207, 176, 176, 176) 
#define GRAY70               IRGB(208, 179, 179, 179) 
#define GREY70               IRGB(208, 179, 179, 179) 
#define GRAY71               IRGB(209, 181, 181, 181) 
#define GREY71               IRGB(209, 181, 181, 181) 
#define GRAY72               IRGB(210, 184, 184, 184) 
#define GREY72               IRGB(210, 184, 184, 184) 
#define GRAY73               IRGB(211, 186, 186, 186) 
#define GREY73               IRGB(211, 186, 186, 186) 
#define GRAY74               IRGB(212, 189, 189, 189) 
#define GREY74               IRGB(212, 189, 189, 189) 
#define GRAY75               IRGB(213, 191, 191, 191) 
#define GREY75               IRGB(213, 191, 191, 191) 
#define GRAY76               IRGB(214, 194, 194, 194) 
#define GREY76               IRGB(214, 194, 194, 194) 
#define GRAY77               IRGB(215, 196, 196, 196) 
#define GREY77               IRGB(215, 196, 196, 196) 
#define GRAY78               IRGB(216, 199, 199, 199) 
#define GREY78               IRGB(216, 199, 199, 199) 
#define GRAY79               IRGB(217, 201, 201, 201) 
#define GREY79               IRGB(217, 201, 201, 201) 
#define GRAY80               IRGB(218, 204, 204, 204) 
#define GREY80               IRGB(218, 204, 204, 204) 
#define GRAY81               IRGB(219, 207, 207, 207) 
#define GREY81               IRGB(219, 207, 207, 207) 
#define GRAY82               IRGB(220, 209, 209, 209) 
#define GREY82               IRGB(220, 209, 209, 209) 
#define GRAY83               IRGB(221, 212, 212, 212) 
#define GREY83               IRGB(221, 212, 212, 212) 
#define GRAY84               IRGB(222, 214, 214, 214) 
#define GREY84               IRGB(222, 214, 214, 214) 
#define GRAY85               IRGB(223, 217, 217, 217) 
#define GREY85               IRGB(223, 217, 217, 217) 
#define GRAY86               IRGB(224, 219, 219, 219) 
#define GREY86               IRGB(224, 219, 219, 219) 
#define GRAY87               IRGB(225, 222, 222, 222) 
#define GREY87               IRGB(225, 222, 222, 222) 
#define GRAY88               IRGB(226, 224, 224, 224) 
#define GREY88               IRGB(226, 224, 224, 224) 
#define GRAY89               IRGB(227, 227, 227, 227) 
#define GREY89               IRGB(227, 227, 227, 227) 
#define GRAY90               IRGB(228, 229, 229, 229) 
#define GREY90               IRGB(228, 229, 229, 229) 
#define GRAY91               IRGB(229, 232, 232, 232) 
#define GREY91               IRGB(229, 232, 232, 232) 
#define GRAY92               IRGB(230, 235, 235, 235) 
#define GREY92               IRGB(230, 235, 235, 235) 
#define GRAY93               IRGB(231, 237, 237, 237) 
#define GREY93               IRGB(231, 237, 237, 237) 
#define GRAY94               IRGB(232, 240, 240, 240) 
#define GREY94               IRGB(232, 240, 240, 240) 
#define GRAY95               IRGB(233, 242, 242, 242) 
#define GREY95               IRGB(233, 242, 242, 242) 
#define GRAY96               IRGB(234, 245, 245, 245) 
#define GREY96               IRGB(234, 245, 245, 245) 
#define GRAY97               IRGB(235, 247, 247, 247) 
#define GREY97               IRGB(235, 247, 247, 247) 
#define GRAY98               IRGB(236, 250, 250, 250) 
#define GREY98               IRGB(236, 250, 250, 250) 
#define GRAY99               IRGB(237, 252, 252, 252) 
#define GREY99               IRGB(237, 252, 252, 252) 
#define GRAY100              IRGB(238, 255, 255, 255) 
#define GREY100              IRGB(238, 255, 255, 255) 
 

#endif

                                                   
